#! /bin/sh

SERVER_ROOT="/opt/TrendMicro/Pixiebob/Server/"
INIT_NETNS_FLAG="/dev/shm/init_netns.flag"
INIT_NETNS_LOG="${SERVER_ROOT}logs/init_netns.log"
SYS_PORT_NS="sys-port-ns"
PG_FILE="/tmp/.s.PGSQL.5432"


if [ ! -f ${INIT_NETNS_FLAG} ]; then
    touch ${INIT_NETNS_FLAG}
    # Init network namespace
    # 1. Check if port binding is enabled
    count=0
    while [[ ! -e ${PG_FILE} && ${count} -lt 3 ]]; do
        echo "[`date`] Wait database to be ready.." >> ${INIT_NETNS_LOG} 2>&1
        count=$((count+1))
        sleep 5
    done

    if [ ${count} == 3 ]; then
        echo "[`date`] Wait database timeout, exit." >> ${INIT_NETNS_LOG} 2>&1
        exit 1
    fi

    enable_port_binding=`/usr/bin/psql -U pixiebob -c "SELECT value from tb_system_settings where key='enable_port_binding'" -A -t` >> ${INIT_NETNS_LOG} 2>&1
    if [ "${enable_port_binding}" == "1" ]; then
        echo "[`date`] Port binding enabled, configure network namespace." >> ${INIT_NETNS_LOG} 2>&1
        # Configure port binding
        /usr/sbin/ip netns add ${SYS_PORT_NS} >> ${INIT_NETNS_LOG} 2>&1
        /usr/sbin/ip netns exec sys-port-ns ip link set dev lo up >> ${INIT_NETNS_LOG} 2>&1
        /usr/sbin/ip link set eth1 netns sys-port-ns >> ${INIT_NETNS_LOG} 2>&1
        /usr/sbin/ip netns exec sys-port-ns /usr/sbin/ifup eth1 >> ${INIT_NETNS_LOG} 2>&1
    fi
fi

